/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_19;
//ESCA*JAVA0267
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import djbuch.kapitel_06.GC;


import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.RichTextItem;
import lotus.domino.RichTextStyle;
import lotus.domino.Session;

/**
 *
 * Baut eine eigene lokale Notes Session auf und schreibt in die spezifizierte Notesdatenbank den Inhalt eines LogFiles in ein neues eigenes Dokument.
 * @author Thomas Ekert
 */
public class NotesLogWriter extends lotus.domino.NotesThread {
	
	private String dominoServer = "unknown";
	private String dominoDb = "noDb";
	private String dominoPwd = null;
	private String iiopServer = null;
	private String iiopUser = null;
	private String logFileName= null;
	private String replication = "YES";
	
	private NotesLogWriter (String dServer, String db, String server, String user, String pwd, String fileName, String repl) {
		dominoServer = dServer;
		iiopServer = server;
		iiopUser = user;
		dominoPwd = pwd;
		dominoDb = db;
		logFileName = fileName;
		replication = repl;
	}
	/**
	 * Schreibt die mit <b>fileName</b> bezeichnete Datei in ein NotesDocument und
	 * hinterlegt zustzlich Informationen ber diesen Vorgang (Servername, Datum)
	 * @param dServer - Domino Server, auf dem sich die DB befindet, in die geschrieben werden soll.
	 * @param db - Datenbank, in die geschrieben werden soll.
	 * @param server - DIIOP Server, mit dem (optional) die Verbindung aufgebaut werden soll - darf
	 * null sein, dann wird eine lokale Session aufgebaut
	 * @param user - DIIOP User, ber den die (optionale) IIOP Verbindung aufgebaut wird.
	 * @param pwd - Passwort fr lokale, bzw. IIOP Session
	 * @param fileName - Dateiname der zu loggenden Datei.
	 * @param replication - Zustzlich wird ein Feld F_Replication=<b>replication</b> angelegt.
	 * Dies erleichtert eine Unterscheidung, welche Dokumente der Datenbank repliziert werden sollen.
	 */
	public static synchronized void writeToDomino (String dServer, String db, String server, String user, String pwd, String fileName, String replication) {
		NotesLogWriter nlw = new NotesLogWriter (dServer, db, server, user, pwd, fileName, replication);
		nlw.run();
		try {
			nlw.join();
		}
		catch (InterruptedException e) {
			System.err.println ("Fatal: " +  e.toString());
		}
	}
	
	public void runNotes () {
		BufferedReader br = null;
		Session session = null;
		Database db = null;
		Document doc = null;
		RichTextItem rti = null;
		RichTextStyle rts = null;
		try {
			session = NotesFactory.createSession(iiopServer, iiopUser, dominoPwd);
			db = session.getDatabase(dominoServer,dominoDb);
			doc = db.createDocument();
			doc.replaceItemValue("Form", "FO_LogFileJava");
			doc.replaceItemValue("F_Servername",db.getServer());
			doc.replaceItemValue("F_Replicate", replication);
			doc.replaceItemValue("F_NotesLogWriter", "1");
			doc.replaceItemValue("F_Created", session.createDateTime(new Date()));
			br = new BufferedReader (new FileReader (logFileName));
			String tmp = br.readLine();
			rti = doc.createRichTextItem("F_Events");
			rts = session.createRichTextStyle();
			rts.setFont(RichTextStyle.FONT_COURIER);
			rts.setFontSize(8);
			rti.appendStyle(rts);
			boolean errorfound=false;
			while (tmp!=null) {
				if (!errorfound && tmp.indexOf(DJLog.logSymbol(DJLog.ERROR)) != -1) {
					doc.replaceItemValue("F_Error","1");
					errorfound=true;//spart sptere indexOf Evaluierungen...
				}
				rti.appendText(tmp);
				rti.addNewLine(1);
				tmp = br.readLine();
			}
			doc.save (true,false);
		} catch (FileNotFoundException e) {
			System.err.println ("Fatal: " +  e.toString());
		} catch (IOException e) {
			System.err.println ("Fatal: " +  e.toString());
		} catch (NotesException e) {
			System.err.println ("Fatal: " +  e.toString());
		} finally {
			try {
				if (br != null) {
					br.close();
				}
			} catch (IOException e) {
				// do nothing
			}
			GC.recycle (rti);
			GC.recycle (doc);
			GC.recycle (db);
			GC.recycle (session);
		}
	}

}
